# Cache configuration

PIMF's caching makes it simple. PIMF provides following cache storages out of the box:

- File System
- PDO
- Memcached
- APC / APCu
- Redis
- Wincache
- DBA
- Memory (Arrays)

By default, PIMF is configured to use the file system cache storage. It`s ready to go out of the box with no configuration.
The file system storage stores cached items as files in the cache directory. If you're satisfied with this storage, no other configuration is 
required. File system cache is stored in the **app/YourAppName/_cache/** directory, so make sure it's writeable. You're ready to start using it.

```php
'cache' => array(

   // Cache storage 'pdo', 'file', 'memcached', 'apc',
   // 'redis', 'dba', 'wincache', 'memory'
   'storage' => 'file',

   // If using file storage - default is null
   'storage_path' => 'app/MyFirstBlog/_cache/',

   // If using the PDO (database) cache storage
   'database' => array(
     'storage' => 'sqlite',
     'database' => 'app/MyFirstBlog/_cache/blog-cache.db',
   ),

   // If using Memcached and APC to prevent collisions
   // with other applications on the server. Feel free to
   // change this value.
   'key' => 'pimfmaster',

   // Memcached servers - for more check out: http://memcached.org
   'memcached' => array(
     array('host' => '127.0.0.1', 'port' => 11211, 'weight' => 100),
   ),
),
```

### Database Storage
The database cache storage uses a given database table as a simple key-value store. To get started, first set the name of the database
table in [config.app.php](https://github.com/gjerokrsteski/pimf-blog/blob/master/app/config.app.php). Once your configuration and table is setup, you're ready to start caching!
To start using database sessions, you will first need to configure your database connection. Next, you will need to create a session table. However, you may also use
PIMF's command-line to generate the table for you!

    php pimf core:create_cache_table


### Memcached Storage
Memcached is an ultra-fast, open-source distributed memory object caching system. Before using PIMFS's Memcached storage, you will need to
install and configure Memcached and the PHP Memcache extension on your server. Once Memcached is installed on your server you must set the
storage in the [config.app.php](https://github.com/gjerokrsteski/pimf-blog/blob/master/app/config.app.php) file.

### Redis Storage
Redis is an open source, advanced key-value store. It is often referred to as a data structure server since keys can contain strings,
hashes, lists, sets, and sorted sets. Before using the Redis cache storage, you must configure your Redis servers. Now you can just set the
storage in the [config.app.php](https://github.com/gjerokrsteski/pimf-blog/blob/master/app/config.app.php) file.

### DBA Storage
The DBA is ultra-fast storage that uses the database (dbm-style) abstraction layer to cache/store your PHP objects, strings, integers or arrays. You don`t have
to matter about the size of the cache-file. It depends on the free space of your disk. You have to compile your PHP **–enable-dba=shared** and
**–with-[qdbm|flatfile|db4]** before using it.

### In-Memory Storage
The **memory** cache storage does not actually cache anything to disk. It simply maintains an internal array of the cache data for the current
request. This makes it perfect for unit testing your application in isolation from any storage mechanism. It should never be used as a **real** cache storage.
